/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.shadowmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.api.IGroupShadow;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIStealth;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.MobInfo;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityDarkling
extends EntityCreatureTameable
implements IMob,
IGroupShadow {
    protected static final DataParameter<Integer> LATCH_TARGET = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> LATCH_HEIGHT = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> LATCH_ANGLE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187193_c);
    EntityLivingBase latchEntity = null;
    int latchEntityID = 0;
    double latchHeight = 0.5;
    double latchAngle = 90.0;

    public EntityDarkling(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.defense = 0;
        this.experience = 2;
        this.hasAttackSound = true;
        this.setWidth = 0.5f;
        this.setHeight = 0.5f;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStealth(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this).setRate(20));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this).setSpeed(1.0).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        if (MobInfo.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityChicken.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class).setPackHuntingScale(3, 1));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class).setPackHuntingScale(3, 1));
        }
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 7.0);
        baseAttributes.put("movementSpeed", 0.36);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 1.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151079_bi), 0.25f));
        this.drops.add(new DropRate(new ItemStack(Items.field_151070_bp), 0.5f).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(Items.field_151071_bq), 0.25f));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LATCH_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(LATCH_HEIGHT, (Object)Float.valueOf((float)this.latchHeight));
        this.field_70180_af.func_187214_a(LATCH_ANGLE, (Object)Float.valueOf((float)this.latchAngle));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.hasAttackTarget() && !this.hasLatchTarget() && this.field_70122_E && !this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(6.0f, 0.6, (Entity)this.func_70638_az());
        }
        if (this.hasLatchTarget()) {
            this.field_70145_X = true;
            Vec3d latchPos = this.getFacingPositionDouble(this.getLatchTarget().field_70165_t, this.getLatchTarget().field_70163_u + (double)this.getLatchTarget().field_70131_O * this.latchHeight, this.getLatchTarget().field_70161_v, (double)this.getLatchTarget().field_70130_N * 0.5, this.latchAngle);
            this.func_70107_b(latchPos.field_72450_a, latchPos.field_72448_b, latchPos.field_72449_c);
            double distanceX = this.getLatchTarget().field_70165_t - this.field_70165_t;
            double distanceZ = this.getLatchTarget().field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)MathHelper.func_181159_b((double)distanceX, (double)distanceZ)) * 57.295776f;
            if (!this.field_70170_p.field_72995_K) {
                if (this.getLatchTarget().func_70089_S() && !this.func_70090_H()) {
                    if (this.updateTick % 40L == 0L) {
                        float damage = this.getAttackDamage(1.0);
                        if (this.meleeAttack((Entity)this.getLatchTarget(), damage)) {
                            this.func_70691_i(damage * 2.0f);
                        }
                    }
                } else {
                    this.func_70107_b(this.getLatchTarget().field_70165_t, this.getLatchTarget().field_70163_u, this.getLatchTarget().field_70161_v);
                    this.setLatchTarget(null);
                    this.field_70145_X = false;
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else {
            this.field_70145_X = false;
        }
    }

    public EntityLivingBase getLatchTarget() {
        try {
            if (this.field_70170_p.field_72995_K) {
                this.latchHeight = ((Float)this.field_70180_af.func_187225_a(LATCH_HEIGHT)).floatValue();
                this.latchAngle = ((Float)this.field_70180_af.func_187225_a(LATCH_ANGLE)).floatValue();
                int latchEntityID = (Integer)this.func_184212_Q().func_187225_a(LATCH_TARGET);
                if (latchEntityID != this.latchEntityID) {
                    Entity possilbeLatchEntity;
                    this.latchEntity = null;
                    this.latchEntityID = latchEntityID;
                    if (latchEntityID != 0 && (possilbeLatchEntity = this.field_70170_p.func_73045_a(latchEntityID)) != null && possilbeLatchEntity instanceof EntityLivingBase) {
                        this.latchEntity = (EntityLivingBase)possilbeLatchEntity;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.latchEntity;
    }

    public void setLatchTarget(EntityLivingBase entity) {
        this.latchEntity = entity;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (entity == null) {
            this.func_184212_Q().func_187227_b(LATCH_TARGET, (Object)0);
            return;
        }
        this.func_184212_Q().func_187227_b(LATCH_TARGET, (Object)entity.func_145782_y());
        this.latchHeight = 0.25 + 0.75 * this.func_70681_au().nextDouble();
        this.latchAngle = 360.0 * this.func_70681_au().nextDouble();
        this.field_70180_af.func_187227_b(LATCH_HEIGHT, (Object)Float.valueOf((float)this.latchHeight));
        this.field_70180_af.func_187227_b(LATCH_ANGLE, (Object)Float.valueOf((float)this.latchAngle));
    }

    public boolean hasLatchTarget() {
        return this.getLatchTarget() != null;
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (this.hasLatchTarget()) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        double targetKnockbackResistance = 0.0;
        if (target instanceof EntityLivingBase) {
            targetKnockbackResistance = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
            ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        }
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(targetKnockbackResistance);
        }
        if (!this.hasLatchTarget() && target instanceof EntityLivingBase && !this.func_70090_H()) {
            this.setLatchTarget((EntityLivingBase)target);
        }
        return true;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean canStealth() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isMoving()) {
            return false;
        }
        return this.testLightLevel() <= 0;
    }

    @Override
    public void startStealth() {
        if (this.field_70170_p.field_72995_K) {
            EnumParticleTypes particle = EnumParticleTypes.SPELL_WITCH;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            for (int i = 0; i < 100; ++i) {
                this.field_70170_p.func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        super.startStealth();
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76440_q) {
            return false;
        }
        if (ObjectManager.getPotionEffect("Fear") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("Fear")) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }
}

